/*
 * Decompiled with CFR 0.152.
 */
package sedonac.test;

import sedonac.CompilerException;
import sedonac.test.CompileTest;

public class DefiniteAssignmentTest
extends CompileTest {
    public void testUnary() {
        this.verify("z=0; b1=\n!b2;\n--a;\n++b;\nc--;\nd++;\nz=~e;\n", new String[]{"3:2:", "4:3:", "5:3:", "6:1:", "7:1:", "8:4:"});
    }

    public void testOpEq() {
        this.verify("z=0;\na |= 0x01\nb &= 0x02\nc ^= 0x04\nd <<= 2\ne >>= 1\n", new String[]{"3:1:", "4:1:", "5:1:", "6:1:", "7:1:"});
        this.verify("z=0\na += 1\nb -= 1\nc *= 1\nd /= 1\ne %= 1\n", new String[]{"3:1:", "4:1:", "5:1:", "6:1:", "7:1:"});
    }

    public void testBool() {
        this.verify("z=0; if (((a=1)==1) && (1<2)){x=0} a+=1\nif (true && true && ((b=1) == 1)){x=0} b+=1\nif (false || ((c=1)==1)){x=0} c+=1\nif (false || false || ((d=1)==1)){x=0} d+=1\nif ( (((e=0)==0) && (1<2)) && false){x=0} e+=1\n");
        this.verify("z=0; if (1<2 && ((a=0)==0)){x=0}\na+=1\nif (false && ((b=1) == 1)){x=0}\nb+=1\nif (true && (1<2) && ((c=1)==1)){x=0}\nc+=1\nif (true || ((d=1)==1)){x=0}\nd+=1\nif ((1<2) || ((e=0)==0)){x=0}\ne+=1\nif ( ((1<2) && ((f=0)==0)) || ((f=0)==0)){x=0}\nf+=1\n", new String[]{"3:1:", "5:1:", "7:1:", "9:1:", "11:1:", "13:1:"});
    }

    public void testIfAndTernary() {
        this.verify("z = 0; if (x<0) a = 1; else if (x<1) a = 2; else a = 3; a += 1\nif (x<0) { if (x<1) b = 1; else b = 2 } else{ if (x<2) b = 3; else b = 4} b += 1\nif (true) c = 1; c += 1\nif (false) {x+=1} else {d=1} d+=1\nz = (x<0) ? (e=0) : (f=0)\n");
        this.verify("z=0; if (x<0) a = 0\na += 1\nif (true) {x+=1} else {b=1}\nb += 1\nif (false) {c=1} else {x+=1}\nc += 1\nif (x<1) d = 0; else if (x<2) d = 1\nd += 1\n", new String[]{"3:1:", "5:1:", "7:1:", "9:1:"});
        this.verify("z = (x<0) ?\na :\nb", new String[]{"3:1:", "4:1:"});
        String[] stringArray = new String[]{"3:1:"};
        this.verify("z = ((a=0) == 0) ? a :\nb", stringArray);
        this.verify("z = (x==0) ? (a=0) :\nb", stringArray);
        this.verify("z = (x==0) ?\na : (a=0)", stringArray);
    }

    public void testFor() {
        this.verify("z=0; for(a=0; a<10; ++a){}\nfor(int i=0; i<10; ++b){b=0}\nfor(int i=0; (c=i)<10; ++i){c+=1}\nfor(int i=(d=0); d<10; ++d){}\nfor(;;){e=0; break} e+=1\n");
        this.verify("z=0; for(;\na<10; ++a){}\nfor(;x<10;\nb++){}\nfor(;;){\nc++; break}\nfor(int i=0; i<10; ++i) d=0\nd+=1\n", new String[]{"3:1:", "5:1:", "7:1:", "9:1:"});
    }

    public void testSwitch() {
        this.verify("switch(z=x){case 0: default: a=0} a+=1\nswitch(x){default: b=0} b+=1\n");
        this.verify("switch(z=x) {case 0: a=0}\na+=1\nswitch(x) {case 0: b=0; default: x=0}\nb+=1\nswitch(x) {case 1: c=0; case 2: break; case 3: case 4: c=4; break; case 5: default: c = 6}\nc+=1\n", new String[]{"3:1:", "5:1:", "7:1:"});
    }

    public void testWhile() {
        this.verify("while((z=0) < 1){}\n");
        this.verify("z=0; while(true) { if(1<2){break} a=0 }\na+=1\nwhile(Sys.ticks()<1000L){b=0}\nb+=1\n", new String[]{"3:1:", "5:1:"});
    }

    public void testDoWhile() {
        this.verify("z=0; do{a=0}while(1<2); a+=1\ndo{continue}while((b=0)<1); b+=1\n");
        this.verify("z=0; do{ if(Sys.ticks()<1L){a=0}else{break} }while(true);\na+=1\ndo{ if(Sys.ticks()<1L){break} b=0 }while(true);\nb+=1\ndo{ if(Sys.ticks()<1L){break} }while((c=0)<1);\nc+=1\n", new String[]{"3:1:", "5:1:", "7:1:"});
    }

    public void testReturn() {
        this.verify("z=0;if (Sys.ticks()>1L){ if (Sys.ticks()>1L){a=0}else{return 1} }else{return 1}a+=1\nwhile (true) { if(Sys.ticks()>1L) return 1; else if (Sys.ticks()>2L) return 2; else b=0 }b+=1\ndo{ if(Sys.ticks()>1L) return 0; else c=0; }while(1<2); c+=1\n");
        this.verify("", new String[]{"3:8:"});
    }

    public void testMisc() {
        this.verify("z =\ns1.length() + \nstrings[0]?.length()\nSys.intStr(\na)\nints[\nb] = 0\n", new String[]{"3:1:", "4:1:", "6:1:", "8:1:"});
    }

    private final void verify(String string) {
        this.verify(string, new String[0]);
    }

    private final void verify(String string, String[] stringArray) {
        this.compile(this.genClass(string));
        CompilerException[] compilerExceptionArray = this.compiler.errors();
        boolean bl = false;
        if (compilerExceptionArray.length == stringArray.length) {
            bl = true;
        }
        this.verify(bl);
        int n = 0;
        while (n < compilerExceptionArray.length) {
            boolean bl2 = false;
            if (compilerExceptionArray[n].toLogString().indexOf(stringArray[n]) >= 0) {
                bl2 = true;
            }
            this.verify(bl2);
            ++n;
        }
    }

    private final String genClass(String string) {
        return "class DefAss extends Component { static inline int[3] ints; int x = 0;" + "int func(int param) {int a; int b; int c; int d; int e; int f; int g; int z;" + "Str s1; Str[] strings; bool b1; bool b2;\n" + string + "\nreturn z\n}" + "\n}";
    }
}

